function results = trial_cv2(temp_raster,times,bin_wid_org)

% Citation: Saleh F, Fakharian M & Ghazizadeh A "Stimulus presentation can enhance spiking irregularity across subcortical and cortical regions." 2021

%% kass method
%%% temp_raster n_trial * 1
cv_count = 100;
temp_raster = cellfun(@(x) reshape(x,length(x),1),temp_raster,'UniformOutput',false);
results = struct();
all_trial_cv2 = nan(cv_count,length(times));
mean_trial_cv2 = all_trial_cv2;

for tim_bin=1:length(times)
    period = [times(tim_bin)-bin_wid_org/2,times(tim_bin)+bin_wid_org/2];
    isi_cell_temp = cellfun(@(x) diff(x((x>period(1)) & (x<period(2)))),temp_raster,'UniformOutput',false);
    isi_cell_temp_count = cellfun(@(x) length(x),isi_cell_temp,'UniformOutput',false);
    isi_mat_temp_count = cell2mat(isi_cell_temp_count);
    isi_cell_not_zero = isi_cell_temp(isi_mat_temp_count>1);
    cv2_trial = cellfun(@(x) var(x)/mean(x)^2,isi_cell_not_zero,'UniformOutput',false);
    all_isi = cell2mat(isi_cell_not_zero);
    %k_trial = cellfun(@(x) 2/nanmean(x.^2) - 0.5 ,cv_n,'UniformOutput',false);
    %k_trials = cell2mat(k_trial);
    all_cv2_trials = cell2mat(cv2_trial);
    all_cv2_trials(isnan(all_cv2_trials)) = [];
    if ((length(all_isi)>10) && (length(all_cv2_trials)>10))
        all_trial_cv2(:,tim_bin) =  bootstrp(cv_count,@(x) var(x) / mean(x)^2 ,all_isi); 
        mean_trial_cv2(:,tim_bin) =  bootstrp(cv_count,@(x) mean(x),all_cv2_trials); 
    end
end

results.all_trial_cv2 = mean(all_trial_cv2);
results.all_trial_cv2_std = std(all_trial_cv2);
results.mean_trial_cv2 = mean(mean_trial_cv2);
results.mean_trial_cv2_std =  std(mean_trial_cv2);

end